#ifndef _PAM_UNIX_CLUSTER_H
#define _PAM_UNIX_CLUSTER_H

/* Files we may open */
#define DEFAULT_PASSWD_FILE		"/etc/passwd"
#define	DEFAULT_PASSWD_TMPFILE		"/etc/npasswd"
#define DEFAULT_SHADOW_FILE		"/etc/shadow"
#define DEFAULT_SHADOW_TMPFILE		"/etc/nshadow"
#define DEFAULT_OLD_PASSWORDS_FILE	"/etc/security/opasswd"
#define DEFAULT_OLD_PASSWORDS_TMPFILE	"/etc/security/nopasswd"
#define DEFAULT_LOCKFILE		"/etc/.pwd.lock"
#define DEFAULT_TEMPFILE		"/etc/.pwdXXXXXX"

enum {
	DEFAULT_UNIX_FILES = 0,
	CLUSTER_UNIX_FILES,
	UNIX_FILE_TYPES,
};

enum {
	_PASSWD_FILE = 0,
	_PASSWD_TMPFILE,
	_SHADOW_FILE,
	_SHADOW_TMPFILE,
	_OLD_PASSWORDS_FILE,
	_OLD_PASSWORDS_TMPFILE,
	_LOCKFILE,
	_TEMPFILE,
	UNIX_FILES_MAX,
};

#define	CLUSTER_ROOTDIR			"/etc/cluster_rootdir"
#define CLUSTER_ROOTDIRLEN		1024
#define UNIX_FILENAMELEN		22	/* "/etc/security/nopasswd" */
#define UNIX_FILES_MAXLEN		CLUSTER_ROOTDIRLEN+UNIX_FILENAMELEN

extern char *map_unix_files(unsigned int ctrl, int type);

/* Map file type to filename */
#define PASSWD_FILE		map_unix_files(ctrl,_PASSWD_FILE)
#define PASSWD_TMPFILE		map_unix_files(ctrl,_PASSWD_TMPFILE)
#define SHADOW_FILE		map_unix_files(ctrl,_SHADOW_FILE)
#define SHADOW_TMPFILE		map_unix_files(ctrl,_SHADOW_TMPFILE)
#define OLD_PASSWORDS_FILE	map_unix_files(ctrl,_OLD_PASSWORDS_FILE)
#define OLD_PASSWORDS_TMPFILE	map_unix_files(ctrl,_OLD_PASSWORDS_TMPFILE)
#define LOCKFILE		map_unix_files(ctrl,_LOCKFILE)
#define TEMPFILE		map_unix_files(ctrl,_TEMPFILE)

#ifdef HELPER_COMPILE
extern int read_cluster_rootdir(void);
#else
extern int read_cluster_rootdir(pam_handle_t *pamh);
#endif
extern void init_unix_files(void);

#endif /* _PAM_UNIX_CLUSTER_H */
