/*
 * Copyright information at end of file.
 */

#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <security/pam_ext.h>
#include "passverify.h"
#include "support.h"
#include "cluster.h"

/* The actual filenames */
static char unix_files[UNIX_FILE_TYPES][UNIX_FILES_MAX][UNIX_FILES_MAXLEN];

/* The cluster rootdir */
static char cluster_rootdir[CLUSTER_ROOTDIRLEN] = "";

#ifdef HELPER_COMPILE
#define report_error(format, args...)	\
	helper_log_err(LOG_ERR, format , ## args)
#else
#define report_error(format, args...)	\
	pam_syslog(pamh, LOG_ERR, format , ## args)
#endif

#ifdef HELPER_COMPILE
int read_cluster_rootdir(void)
#else
int read_cluster_rootdir(pam_handle_t *pamh)
#endif
{
	int pos = readlink(CLUSTER_ROOTDIR,
			   cluster_rootdir, sizeof(cluster_rootdir) - 1);
			
	if (pos < 0)
		report_error("Invalid " CLUSTER_ROOTDIR ": %s",
			     strerror(errno));
	else
		cluster_rootdir[pos] = '\0';
	
	return pos;
}

#define STRCAT(type)	\
	strcpy(unix_files[DEFAULT_UNIX_FILES][type], DEFAULT ## type); \
	strcat(unix_files[CLUSTER_UNIX_FILES][type], DEFAULT ## type)

void init_unix_files(void)
{
	unsigned int i;
	
	for (i = 0; i < UNIX_FILES_MAX; i++)
		strcpy(unix_files[CLUSTER_UNIX_FILES][i], cluster_rootdir);
	
	STRCAT(_PASSWD_FILE);
	STRCAT(_PASSWD_TMPFILE);
	STRCAT(_SHADOW_FILE);
	STRCAT(_SHADOW_TMPFILE);
	STRCAT(_OLD_PASSWORDS_FILE);
	STRCAT(_OLD_PASSWORDS_TMPFILE);
	STRCAT(_LOCKFILE);
	STRCAT(_TEMPFILE);
}

char * map_unix_files(unsigned int ctrl, int type)
{	
	return unix_files[!!on(UNIX_CLUSTER,ctrl)][type];
}	

/* ****************************************************************** *
 * Copyright (c) Jozsef Kadlecsik, 2008
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License, in which case the provisions of the GPL are
 * required INSTEAD OF the above restrictions.  (This clause is
 * necessary due to a potential bad interaction between the GPL and
 * the restrictions contained in a BSD-style copyright.)
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
